
var storyActions = function(){
	
	this.curOption = '';
	this.curElement = false;
	
	var galurl = '/gallery/main.php?';
	var curFiles = [];

	return {
		start:function() {

			storyActions.url = window.location.href;
			storyActions.title = $('#content h2:first').text();
			shareActions.init();
		},
		togglePanel:function(option,element) {
			var element = $(element).parent();
		
			var panel = option.panel;
		
			if(panel && storyActions.curOption == option) {
				//Made panel and is displayed, so hide
				storyActions.cancel();
			} else {
				if(storyActions.curOption && storyActions.curOption != option) {
					storyActions.cancel();
				}
				storyActions.curOption = option;
				storyActions.curElement = element;
				element.attr('id','curOption');
			
				if(!panel) {
					//Make panel
					panel = $('<div>' + option.getHTML() + '</div>');
					element.append(panel);
				}
			}
			option.panel = panel;
		},
		
		cancel:function() {
			// Unselect current option
			storyActions.curElement.removeAttr('id');
			storyActions.curOption = false;
		}
	}

}();



var shareActions = function() {
	return {
		panel:false,
		
		init:function() {
			$('#story-options')
				.append('<li><a href="#Share" id="share">Bookmark / Share</a></li>');
			
			$('#share').click(function() {
				storyActions.togglePanel(shareActions,this);
				return false;
			});
		},
		getHTML:function() {
			var sites = [
				['Facebook','www.facebook.com/sharer.php?u','t'],
				['MySpace','myspace.com/Modules/PostTo/Pages/?u','t'],
				['Twitter','twitter.com/home?status'],
				['Digg','digg.com/submit?url',0],
				['Mixx','mixx.com/submit/story?page_url',0],
				['StumbleUpon','www.stumbleupon.com/submit?url',0],
				['del.icio.us','del.icio.us/post?url',0],
				['Reddit','reddit.com/submit?url',0],
				['Newsvine','www.newsvine.com/_wine/save?u','h']
			];
			var list = '';
			
			for(var i=0, site; site=sites[i];i++) {
				var name = site[0];
				var urlq = site[1];
				var titleq = site[2]?site[2]:'title';
				var file = site[0].replace(/[^a-zA-Z0-9]/g,'').toLowerCase();
				var img = '/images/icons/' + file + '.png';
				
				var params;
				
				var st = {
					url:encodeURIComponent(storyActions.url),
					title:encodeURIComponent(storyActions.title)
				}
				
				if(name == 'Twitter') {
					params = st.title + ' ' + st.url;
				} else {
					params = st.url + '&' + titleq + '=' + st.title;
				}
				
				var url = 'http://' + urlq + '=' + params;
				
				list += ('<li><a href="'+url+'" target="_blank"><img src="' + img + '" alt="" width="16" height="16" />'+name+'</a></li>');
			}
			
			return '<fieldset class="sharebox">'
				+ '<ul>' + list + '</ul>'
				+ '<input onclick="storyActions.cancel()" type="button" value="Cancel">'
				+ '</fieldset>';
		}
	}
}();

// Page reloader for popup frames
$.reloadPage = function() {
	$.colorbox.close();
	setTimeout(function() {
		location.href = location.href;
	}, 1000);
}		

$(function() {
	
	// Story actions for "view event"
	if($('#story-options').length) {
		storyActions.start();
		return;
	}
	
	// Hide default search submit
	$('#cal_search input[type=submit]').hide();
	
	// Make popups work
	var boxData = {width:"80%", height:"80%", iframe:true, transition:'none'};
	
	var overlay_link = null;
	
	var is_day = $('#pg_day').length;
	
	$('a.popup').each(function() {
		this.href += '&size=small';
		
		var link = $(this);
		if(link.colorbox) {
			link.colorbox(boxData);
		}

		if(is_day) {
			// Add hover effect for links (in case of overlapping)
			
			var date_elem = link.parents('.date');
			if(!date_elem.length) return;
			
			var evt_class = $.trim(date_elem.attr('class').replace('date', ''));
			
			var clone = link.clone(true).addClass('overlay_link').addClass(evt_class).css('color', 'white');
			
			$.data(this, 'clone', clone);
			
			link.mouseenter(function ( e ) {
				overlay_link = link.data('clone').css(link.offset()).show();
				$('body').append(overlay_link);
			});
			
			clone.mouseleave(function ( e ) {
				if(overlay_link) overlay_link.hide();
			});
		}
		
	});
	
	if($('#pg_calendar_home').length) {

		if(!$.browser.msie) {
			$('.scal_content').delegate('table.grid th.cal_top a', 'click', function(e) {
				e.preventDefault();
				$.get(this.href + '&ajax=1', function(data) {
					$('table.grid').replaceWith(data);
				});
			});
		}

		$('#cal_search_results').click(function(e) {
			if(e.target.tagName.toLowerCase() === 'a') {
				e.preventDefault();
				boxData.href = e.target.href + '&size=small';
				$.colorbox(boxData);
			}
		});
		
		$('div.notif_form form').submit(function() {
			var form = $(this);
			var fdata = form.serialize();
			var block = false;
			$.each(this.elements, function() {
				if(this.type == 'submit') return;
				
				if(!this.value.length) {
					alert("Error: " + this.name + ' field was not entered');
					this.focus();
					block = true;
					return false;
				}
			});
			
			if(block) {
				return false;
			} else {
				$.post(this.action, fdata, function(data) {
					var elem = $('<p class="notif_note">' + data + '</p>');
					form.append(elem);
					setTimeout(function() {
						elem.slideUp();
					}, 10000);
				});
				return false;
			}
		});
	}
	
	var results = $('#cal_search_results');
	var sbox = $('#cal_search_q');
	var scache = {};
	
	// Flush cache every hour
	setInterval(function() {
		scache = {};
	}, 1000 * 60 * 60);
	
	function checkEmpty() {
		if(!sbox[0].value.length) {
			results.hide();
		}
	}

	var sel_pos = -1;
	
	function showResults(html) {
		if(!html) {
			html = '<p><em>No events found</em></p>';
		}
		results.html(html).show();
		sel_pos = -1;
	}
	

	
	$('#cal_search form').submit(function() {
		var hl = results.find('p.hlight');
		if(hl.length) {
			hl.find('a').click();
		}
		return false;
	});
	
	$('#pg_calendar_home').click(function(e) {
		if(!$(e.target).parents('#cal_search, #cal_search_results').length) {
			results.hide();
		}
	});
	
	sbox.focus(function() {
		if(this.value.length) {
			if(results.html().length) {
				results.show();
			} else {
				sbox.keyup();
			}
		} else {
			results.hide();
		}
	}).keyup(function(e) {
		switch ( e.keyCode ) {
		case 38: //up
		case 40: //down
			e.preventDefault();
			var paras = results.find('p');
			if(paras.length) {
				paras.filter('.hlight').removeClass('hlight');
				if(e.keyCode === 40) {
					sel_pos++;
				} else {
					sel_pos--;
				}
				if(sel_pos > paras.length) {
					sel_pos = 0;
				} else if(sel_pos < 0) {
					sel_pos = paras.length - 1;
				}
				paras.eq(sel_pos).addClass('hlight');
				return;
			}
			break;
		}
		setTimeout(checkEmpty, 20);
		var val = this.value;
		
		if(!val) {
			results.hide();
		} else if(val in scache) {
			showResults(scache[val]);
		} else {
			$.getJSON('search.php?q=' + val, function(data) {
				var events = data.events;
				var html_output = '';
				
				for(var i=0, l=events.length; i < l; i++) {
					var event = events[i];
					html_output += '<p><a href="show_event.php?id=' + event.id + '">' + event.title + '</a> (' + event.date + ')</p>';
				}
				
				scache[val] = html_output;
				
				showResults(html_output);
			});
		}
	});
});

$(function() {
	var max_height = 70;
	
// 	if($('#pg_week,#pg_day').length) {
// 		var curIndex = 1;
// 		var dates = $('.date');
// 		var curElem = null;
// 		dates.click(function() {
// 			if(this !== curElem) {
// 				this.style.zIndex = ++curIndex;
// 				curElem = this;
// 			}
// 		});
// 	}
	if($('#pg_month').length) {
		var overlay = $('<div>').hide().css({
			position: 'absolute'
		});
		
		$('div.scal_content').append(overlay);
	
		var strShow = 'Show all ▼';
		var strHide = 'Hide ▲';
	
	
		$('td.day > div').each(function() {
			var daywrap = $(this);
			if(daywrap.height() > max_height) {
				
				
				var show = $('<a href="#" class="show">' + strShow + '</a>').click(function(e) {
					e.preventDefault();
					var link = $(this);
					if(link.text() === strShow) {
					
						// Hide all others
	// 					console.log('to hide', $('a.show:contains(' + strHide + ')'));
						$('a.show:contains(' + strHide + ')').click();
					
						// "Show" by cloning and positioning
						link.text(strHide);
						link.css({
							'margin-bottom': '-1.5em'
						});
						
						var pos = daywrap.position();
						
						overlay
							.empty()
							.append(daywrap.clone().height('auto').css('overflow', 'visible'))
							.css({
								background: 'white',
								width: daywrap.width(),
								top: pos.top,
								left: pos.left
							})
							.show()
							.find('a.show').replaceWith(link);
							
					} else {
						// "Hide" by removing
						overlay.hide();
						link.text(strShow).css('margin-bottom', 0);
						daywrap.append(link);
					}
					
				});
				daywrap.height(max_height - 2).css('overflow', 'hidden')
					.append(show);
			}
		});
	}
});