<?php
/*
<?xml version="1.0" encoding="utf-8"?>
<module>
        <name>Month View</name>
        <author>Dana C. Hutchins</author>
        <url>http://supercali.inforest.com/</url>
        <version>1.0.0</version>
        <link_name>Month</link_name>
        <description>The original month calendar grid</description>
        <image></image>
		<install_script></install_script>     
</module>
Supercali Event Calendar

Copyright 2006 Dana C. Hutchins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

For further information visit:
http://supercali.inforest.com/
*/

function showGrid($date) {
	global $title, $niceday, $start_time, $end_time, $venue, $city, $state, $cat, $color, $background, $ed, $usr, $o, $c, $m, $a, $y, $w, $lang, $ap, $status;
	if ($start_time[$date]) {
		ksort($start_time[$date]);
		echo "<ul>\n";
		while (list($t) = each($start_time[$date])) {
			while (list($id,$value) = each($start_time[$date][$t])) {
			
				// Hide proposed from regular users
				$can_edit = $ed[$id];
				$is_proposed = ($status[$id] == 2) || ($status[$id] == 3);
				if(!$can_edit && $is_proposed) {
					continue;
				}
			
				echo "<li>";
				echo '<div class="item calcat' . $cat[$id] . '"';
				echo ">";
				echo "<div class=\"time\">".$value;
// 				if ($end_time[$date][$t][$id]) echo " - ".$end_time[$date][$t][$id];
				echo "</div>\n";
				echo "<div class=\"title\"><a href=\"show_event.php?id=".$id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\" class=\"popup\"";
				echo ">".$title[$id]."</a></div>\n";
				if ($venue[$id]) {
					echo "<div class=\"venue\">".$venue[$id]."</div>\n";
					if ($city[$id]) {
						echo "<div class=\"location\">".$city[$id];
						if ($state[$id]) echo ", ".$state[$id];
						echo "</div>\n";
					}
				}
				echo "</div>";

// print_r($ed);
				if ($ed[$id]==true) {
					echo "<div class=\"edit\">";
					if (($ap[$id]==true) && (($status[$id] == 2) || ($status[$id] == 3))) echo "[<a href=\"admin_actions.php?id=".$id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."&mode=".approve."\">".$lang["approve"]."</a>]&nbsp;&nbsp;";
					echo "[<a href=\"edit_event.php?id=".$id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\" class=\"popup\">".$lang["edit"]."</a>]&nbsp;&nbsp;[<a href=\"delete_event.php?id=".$id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\">".$lang["delete"]."</a>]</div>\n";
				}
				echo "</li>\n";
			}
		}
		echo "</ul>\n";
	}
}

// 
// 		while (list($r) = each($start_fill)) {
// 			while (list($k,$v) = each($start_fill[$r])) {
// 				$v = $v+30;
// 				$left = $left_perc * $r;
// 				
// 				$event_id = $start_event[$r][$k];
// 				
// 				// wrap fix from Vepr				
// 				echo "<div class=\"wrap\"><div class=\"date calcat" . $cat[$event_id] . "\" style=\"";
// 				echo "height: ".$event_length[$r][$k]."px; top: ".$v."px; width: ".$width_perc."%; left:".$left."%;";
// 				if (($status[$event_id] == 2) || ($status[$event_id] == 3)) {
// 					echo " filter:alpha(opacity=90); opacity:.90; zoom: 1; border: 1px dashed ".$color[$event_id].";";
// 				}
// 				echo "\"><div class=\"inner\">";
// 				echo "<span class=\"time\">".$sta_e[$r][$k];
// // 				if ($end_e[$r][$k]) echo " - ".$end_e[$r][$k];
// 				echo "</span>\n";
// 				echo "<div class=\"title\"><a href=\"show_event.php?id=".$event_id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\" onClick=\"openPic('show_event.php?id=".$event_id."&size=small','pop','600','400'); window.newWindow.focus(); return false\"";
// 				echo ">".$title[$event_id]."</a></div>\n";
// 				if ($ed[$event_id]==true) {
// 					echo "&nbsp;&nbsp;<span class=\"edit\">";
// 					if (($ap[$event_id]==true) && (($status[$event_id] == 2) || ($status[$event_id] == 3))) echo "[<a href=\"admin_actions.php?id=".$event_id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."&mode=".approve."\">".$lang["approve"]."</a>]  ";
// 					echo "[<a href=\"edit_event.php?id=".$event_id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\" onClick=\"openPic('edit_event.php?id=".$event_id."&size=small','pop','650','600'); window.newWindow.focus(); return false\">".$lang["edit"]."</a>]  [<a href=\"delete_event.php?id=".$event_id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\">".$lang["delete"]."</a>]</span>\n";
// 				}
// 				echo "</div></div></div>\n";
// 			

function showMonth ($calmonth,$calyear) {
	global $week_titles, $o, $m, $a, $y, $w, $c, $next, $prev,$ly, $lm, $le, $la;
	/* determine total number of days in a month */
	
	$calday = 0;
	$totaldays = 0;
	while ( checkdate( $calmonth, $totaldays + 1, $calyear ) )
	        $totaldays++;
	
	/* build table */
	echo '<table width="100%" class="grid""><tr>'; 
	
	$prev_url = $PHP_SELF . '?o=' . $o . '&w=' . $w . '&c=' . $c . '&m=' . $prev["month"]["m"] . '&a=1&y=' . $prev["month"]["y"];
	$next_url = $PHP_SELF . '?o=' . $o . '&w=' . $w . '&c=' . $c . '&m=' . $next["month"]["m"] . '&a=1&y=' . $next["month"]["y"];
	$show_date = date('F', mktime(0,0,0,$calmonth,1,$calyear)) . '&nbsp;' . date('Y', mktime(0,0,0,$calmonth,1,$calyear));
	?>
	
	<th colspan="7" class="cal_top">
		<a class="nav" href="<?=$prev_url ?>">‹</a>
		<?=$show_date ?>
		<a class="nav" href="<?=$next_url ?>">›</a>
	</th>
</tr>
	<tr>
	
	<?php
	for ( $x = 0; $x < 7; $x++ )
	        echo '<th>', $week_titles[ $x ], '</th>';
	
	/* ensure that a number of blanks are put in so that the first day of the month
	   lines up with the proper day of the week */
	$off = date( "w", mktime( 0, 0, 0, $calmonth, $calday, $calyear ) );
	$offset = $off + 1;
	echo '</tr><tr>';
	if ($offset > 6) $offset = 0;
	for ($t=0; $t < $offset; $t++) {
		if ($t == 0) {
			$offyear = date( "Y", mktime( 0, 0, 0, $calmonth, $calday-$off, $calyear ) );
			$offmonth = date( "m", mktime( 0, 0, 0, $calmonth, $calday-$off, $calyear ) );
			$offday = date( "d", mktime( 0, 0, 0, $calmonth, $calday-$off, $calyear ) );
			echo '<td class="day"><div class="week"><a href="index.php?o=',$le,'&w=',$w,'&c=',$c,'&m=',$offmonth,'&a=',$offday,'&y=',$offyear,'">week</a></div></td>';
		} else {
			echo '<td class="day">&nbsp;</td>';
		}
	}
	/* start entering in the information */
	for ( $d = 1; $d <= $totaldays; $d++ )
	{
			if (($d == date(j)) && ($calmonth == date(m)) && ($calyear == date(Y))) {
				echo '<td class="day" id="today"><div class="daywrap"><div class="day_of_month"><a href="index.php?o=',$la,'&w=',$w,'&c=',$c,'&m=',$calmonth,'&a=',$d,'&y=',$calyear,'">', $d, '</a></div>';
			} else {
				echo '<td class="day"><div class="daywrap"><div class="day_of_month"><span class="shadow">' . $d . '</span><a href="index.php?o=',$la,'&w=',$w,'&c=',$c,'&m=',$calmonth,'&a=',$d,'&y=',$calyear,'">', $d, '</a>';
				if ($offset == 0) echo '<br><div class="week"><a href="index.php?o=',$le,'&w=',$w,'&c=',$c,'&m=',$calmonth,'&a=',$d,'&y=',$calyear,'">week</a></div>';
				echo '</div>';
				
			}
			/* correct date format */
			$coredate = date( "Ymd", mktime( 0, 0, 0, $calmonth, $d, $calyear ) );
			showGrid($coredate);
			echo "</div></td>";
	        $offset++;
	
	        /* if we're on the last day of the week, wrap to the other side */
	        if ( $offset > 6 )
	        {
	                $offset = 0;
	                echo '</tr>';
	                if ( $day < $totaldays )
	                        echo '<tr>';
	        }
	}
	
	/* fill in the remaining spaces for the end of the month, just to make it look
	   pretty */
	if ( $offset > 0 )
	        $offset = 7 - $offset;
	
	for ($t=0; $t < $offset; $t++) {
		echo "<td>&nbsp;</td>";
	}
	/* end the table */
	echo '</tr></table>';
}

include "includes/header.php";

$thismonth = $y."-".$m;
$nextmonth =  $next["month"]["y"]."-".$next["month"]["m"];
grab($thismonth."-01",$nextmonth."-01",$c);
showMonth($m,$y);

include "includes/footer.php";
?>
