<?php
/*
Supercali Event Calendar

Copyright 2007 Dana C. Hutchins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

For further information visit:
http://supercali.inforest.com/
*/
function showGrid($date) {
	global $title, $niceday, $start_time, $end_time, $venue, $city, $state, $cat, $color, $background, $ed, $usr, $o, $c, $m, $a, $y, $w, $lang,$scale,$ap,$status, $day_week_start_hour, $day_week_end_hour;
	$threshold_hour = $day_week_start_hour ? $day_week_start_hour : 0;
	$threshold_min = $day_week_start_hour ? 0 : 30;
	$txi = ($threshold_hour * 60) + $threshold_min;
	if ($start_time[$date]) {
		ksort($start_time[$date]);
		$scale = 1;
			$wait = 1;
		while (list($t) = each($start_time[$date])) {
			
			
			while (list($id,$value) = each($start_time[$date][$t])) {
				if (eregi ("([0-9]{1,2}):([0-9]{2})[ ]?([a|p]m)",$value,$parse_start_time)) {
					if ((eregi("am",$parse_start_time[3])) && ($parse_start_time[1] == 12)) $parse_start_time[1] = $parse_start_time[1] - 12;
					if ((eregi("pm",$parse_start_time[3])) && ($parse_start_time[1] < 12)) $parse_start_time[1] = $parse_start_time[1] + 12;							
					if (strlen($parse_start_time[1]) == 1) $parse_start_time[1] = "0".$parse_start_time[1];
					
					
					if ($end_time[$date][$t][$id]) {
						eregi ("([0-9]{1,2}):([0-9]{2})[ ]?([a|p]m)",$end_time[$date][$t][$id],$parse_end_time);
						if ((eregi("am",$parse_end_time[3])) && ($parse_end_time[1] == 12)) $parse_end_time[1] = $parse_end_time[1] - 12;
						if ((eregi("pm",$parse_end_time[3])) && ($parse_end_time[1] < 12)) $parse_end_time[1] = $parse_end_time[1] + 12;							
						if (strlen($parse_end_time[1]) == 1) $parse_end_time[1] = "0".$parse_end_time[1];
						
					} else {
						$parse_end_time[1] = $parse_start_time[1] + 1;
						if ($parse_end_time[1] > 24) $parse_end_time[1] = 24;
						if ($parse_end_time[1] == 24) $parse_end_time[2] = "00";
						
					}
					
				} elseif($value == "All Day") {
					$parse_start_time[1] = "00";
					$parse_start_time[2] = "00";
					$parse_end_time[1] = "24";
					$parse_end_time[2] = "00";
					
				} elseif($value == "TBA") {
					$parse_start_time[1] = "00";
					$parse_start_time[2] = "00";
					$parse_end_time[1] = "00";
					$parse_end_time[2] = "30";
					
				}
				
				$event_id[] = $id;
				$sxi = ($parse_start_time[1] * 60) + $parse_start_time[2];
				$exi = ($parse_end_time[1] * 60) + $parse_end_time[2];
				if ($sxi < $txi) {
					$sxi = 0;
					if ($exi <= $txi) {
						$exi = 30;
					} else {
						$exi = $exi - $txi + 30;
					}
				} else {
					$sxi = $sxi - $txi + 30;
					$exi = $exi - $txi + 30;
				}
				
				$sh[] = $exi - $sxi - 2;
				$sx[] = $sxi;
				$ex[] = $exi;
				$len = $exi - $sxi;
				$sta[] = $value;
				$end[] = $end_time[$date][$t][$id];
				
			}
		}
		// Disabled by ARPD to leave events in order of time
// 		arsort($sh);
		$start_empty[0][0] = 0;
		$end_empty[0][0] = 1440;
		$indent = 0;
		while (list($k,$v) = each($sh)) {
			$found = false;
			
			reset($start_empty);
			while (list($r) = each($start_empty)) {
				reset($start_empty[$r]);
				while (list($kk,$vv) = each($start_empty[$r])) {
					if (($sx[$k] >= $vv) && ($ex[$k] <= $end_empty[$r][$kk])) {
						$end_empty[$r][] = $end_empty[$r][$kk];
						$end_empty[$r][$kk] = $sx[$k];
						$start_empty[$r][] = $ex[$k];
						$start_fill[$r][] = $sx[$k];
						$end_fill[$r][] = $ex[$k];
						$start_event[$r][] = $event_id[$k];
						$sta_e[$r][] = $sta[$k];
						$end_e[$r][] = $end[$k];
						$event_length[$r][] = $v;
						$found = true;
						break 2;
						
						
						
					}
				}
			}
			if (!$found) {
				$indent++;
				$start_empty[$indent][0] = 0;
				$end_empty[$indent][0] = $sx[$k];
				$start_empty[$indent][1] = $ex[$k];
				$end_empty[$indent][1] = 1440;
				$start_fill[$indent][0] = $sx[$k];
				$end_fill[$indent][0] = $ex[$k];
				$start_event[$indent][0] = $event_id[$k];
				$event_length[$indent][0] = $v;
				$sta_e[$indent][0] = $sta[$k];
				$end_e[$indent][0] = $end[$k];
			}
		}
		$columns = $indent+1;
		$per = 100 / $columns;
		
// 		echo 'cols:' . $columns;
// 		
// 		if($columns == 1) {
// 			$width_perc = 100;
// 			$left_perc = 0;
// 		} else {
			$width_perc = number_format(100 - ($columns * 10), 0);
			
			$left_perc = (100 - $width_perc) / ($columns - 1);
// 		}
		
		$wide = number_format($per,0);
		$notsowide = $wide-1;
		reset($start_fill);
		
		while (list($r) = each($start_fill)) {
			while (list($k,$v) = each($start_fill[$r])) {
				$v = $v+30;
				
				$left = $left_perc * $r;
				
				$event_id = $start_event[$r][$k];
				
				$can_edit = $ed[$event_id];
				$is_proposed = ($status[$event_id] == 2) || ($status[$event_id] == 3);
				
				if(!$can_edit && $is_proposed) {
					continue;
				}
				
				$height = $event_length[$r][$k];
				
				if($height < 64) {
					$height = 'auto';
				}
				
				// wrap fix from Vepr				
				echo "<div class=\"wrap\"><div class=\"date calcat" . $cat[$event_id] . "\" style=\"";
				echo "height: ".$height."px; top: ".$v."px; width: ".$width_perc."%; left:".$left."%;";
				if (($status[$event_id] == 2) || ($status[$event_id] == 3)) {
					echo " filter:alpha(opacity=90); opacity:.90; zoom: 1; border: 1px dashed ".$color[$event_id].";";
				}
				echo "\"><div class=\"inner\">";
				echo "<span class=\"time\">".$sta_e[$r][$k];
// 				if ($end_e[$r][$k]) echo " - ".$end_e[$r][$k];
				echo "</span>\n";
// 				echo "<div class=\"title\"><a href=\"show_event.php?id=".$event_id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\" onClick=\"alert('f');openPic('show_event.php?id=".$event_id."&size=small','pop','600','400'); window.newWindow.focus(); return false\"";
				echo "<div class=\"title\"><a class=\"popup\" href=\"show_event.php?id=".$event_id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\"";
				echo ">".$title[$event_id]."</a></div>\n";
				
// 				print_r($ed);
// 				
				if ($ed[$event_id]==true) {
					echo "&nbsp;&nbsp;<span class=\"edit\">";
					if (($ap[$event_id]==true) && (($status[$event_id] == 2) || ($status[$event_id] == 3))) echo "[<a href=\"admin_actions.php?id=".$event_id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."&mode=".approve."\">".$lang["approve"]."</a>]  ";
					echo "[<a href=\"edit_event.php?id=".$event_id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\" class=\"popup\">".$lang["edit"]."</a>]  [<a href=\"delete_event.php?id=".$event_id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\">".$lang["delete"]."</a>]</span>\n";
				}
				echo "</div></div></div>\n";
			}
		}
	}
	//echo "</div>\n";
}


function showHours() {
	global $day_week_start_hour, $day_week_end_hour, $superpost, $y, $m, $a;
	// build day
	echo "<td class=\"timex\"><table class=\"day\"><tr><td width=\"100%\"><div class=\"time_frame\">\n";
	echo "<div class=\"cell_top\">Time</div>\n";
	echo "<div class=\"cell\">12:00 am ".$day_week_start_min."</div>\n";
	$i = $day_week_start_hour ? $day_week_start_hour : 0;
	$j = $day_week_start_hour ? 0 : 30;
	$max = $day_week_end_hour ? $day_week_end_hour : 24;
	while ($i < $max) {
		if ($j < 10) {
			$j = "0".$j;
			
		}
		if ($i == 0) {
			$h = 12;
			$ap = "am";
		} elseif ($i == 12) {
			$h = $i;
			$ap = "pm";
		} elseif ($i > 12) {
			$h = $i - 12;
			$ap = "pm";
		} else {
			$h = $i;
			$ap = "am";
		}
		$time_str = $h.":".$j." ".$ap;

		echo "<div class=\"cell\">";
		if($superpost) {
// 			$next_start = '';
// 			$next_end = '';
			// next_date=02/17/2011&next_start=8:30 am&next_end=9:00 am
			$next_date = $m . '/' . $a . '/' . $y;
			echo '<a href="add_event.php?size=small&next_date=' . $next_date . '&next_start=' . $time_str . '&next_end=' . $time_str . '" class="popup">';
			echo $time_str;
			echo '</a>';
		}  else {
			echo $time_str;
		}

		echo "</div>\n";
		$j = $j+30;
		if ($j >= 60) {
			$j = "0";
			$i++;
		}
	}
	echo "</div></td></tr></table></td>";

}

function showDay($dy,$dm,$da,$caption="") {
	global $la, $w, $c, $day_week_start_hour, $day_week_end_hour;
	// build day
	echo "<div class=\"single_day_frame\">";
	echo "<div class=\"cell_top\">";
	if($caption) echo $caption;
	else {
		echo '<a href="index.php?o=',$la,'&w=',$w,'&c=',$c,'&m=',$dm,'&a=',$da,'&y=',$dy,'">';
		echo date('D, M j', mktime(0,0,0,$dm,$da,$dy));
		echo '</a>';
	}
	echo "</div>";
	echo "<div class=\"cell\" data-time=\"0:00:".$dm."/".$da."/".$dy."\"></div>\n";
	$i = $day_week_start_hour ? $day_week_start_hour : 0;
	$j = $day_week_start_hour ? 0 : 30;
	$max = $day_week_end_hour ? $day_week_end_hour : 24;
	
	while ($i < $max) {
		if ($j < 10) {
			$j = "0".$j;
			if ($i < 10) $i = $i;
		}
		if ($i == 0) {
			$h = 12;
			$ap = "am";
		} elseif ($i == 12) {
			$h = $i;
			$ap = "pm";
		} elseif ($i > 12) {
			$h = $i - 12;
			$ap = "pm";
		} else {
			$h = $i;
			$ap = "am";
		}
		if ($i < 10) $i = $i;
		//echo "<div class=\"cell\" id=\"".$i.":".$j."\">".$h.":".$j." ".$ap."</div>\n";
		echo "<div class=\"cell\" data-time=\"".$i.":".$j.":".$dm."/".$da."/".$dy."\"></div>\n";
		$j = $j+30;
		if ($j >= 60) {
			$j = "0";
			$i++;
		}
	}
	
	
	
	$sdate = $dy.$dm.$da;
	echo "<div id=\"dates\">\n";
	showGrid($sdate);
	echo "</div>";
	echo "</div>";


}




if ($superpost) {
	$javascript = '';//<script type="text/javascript" src="js/drag.js"></script>';
}
?>