<?php
/*
<?xml version="1.0" encoding="utf-8"?>
<module>
        <name>Upcoming View</name>
        <author>Dana C. Hutchins</author>
        <url>http://supercali.inforest.com/</url>
        <version>1.0.6</version>
        <link_name>Upcoming</link_name>
        <description>Shows Upcoming Events</description>
        <image></image>
		<install_script></install_script>     
</module>
Supercali Event Calendar

Copyright 2006-8 Dana C. Hutchins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

For further information visit:
http://supercali.inforest.com/
*/
// module configuration variables
if (!$hideheader) $hideheader = false; // set to true if calling from another page
if (!$plusmonths) $plusmonths = 1;  // how far out in months to view, if > 1, then you probably want to set $plusdays=0 or vice-versa
if (!$plusdays) $plusdays = 0; // how far out in days to view

/* NOTE: To call this module within your code set $_REQUEST[o] to the ID of this module id shown in modules page of SuperCali.  For example:
$_REQUEST[o] = 5;
$hideheader = true;
chdir ("demo_calendar");
include "index.php";
chdir("../");
unset($_SESSION[o]);
*/

$ajax_month = isset($_GET['ajax']);


function showMonth ($calmonth,$calyear) {
	global $week_titles, $o, $m, $a, $y, $w, $c, $next, $prev,$ly, $lm, $le, $la, $start_time, $status, $ajax_month;
	/* determine total number of days in a month */
	
	$calday = 0;
	$totaldays = 0;
	while ( checkdate( $calmonth, $totaldays + 1, $calyear ) )
	        $totaldays++;
	
	/* build table */
	if(!$ajax_month) {
		echo '<div id="first_col">';
	}
	
	echo '<table width="100%" class="grid""><tr>'; 
	
	$prev_url = $PHP_SELF . '?o=' . $o . '&w=' . $w . '&c=' . $c . '&m=' . $prev["month"]["m"] . '&a=1&y=' . $prev["month"]["y"];
	$next_url = $PHP_SELF . '?o=' . $o . '&w=' . $w . '&c=' . $c . '&m=' . $next["month"]["m"] . '&a=1&y=' . $next["month"]["y"];
	$show_date = date('F', mktime(0,0,0,$calmonth,1,$calyear)) . '&nbsp;' . date('Y', mktime(0,0,0,$calmonth,1,$calyear));
	?>
	
	<th colspan="7" class="cal_top">
		<a class="nav" href="<?=$prev_url ?>">‹</a>
		<?=$show_date ?>
		<a class="nav" href="<?=$next_url ?>">›</a>
	</th>
	</tr><tr>
	<?php 

	for ( $x = 0; $x < 7; $x++ )
	        echo '<th>', substr($week_titles[ $x ], 0, 1) , '</th>';
	
	/* ensure that a number of blanks are put in so that the first day of the month
	   lines up with the proper day of the week */
	$off = date( "w", mktime( 0, 0, 0, $calmonth, $calday, $calyear ) );
	$offset = $off + 1;
	echo '</tr><tr>';
	if ($offset > 6) $offset = 0;
	for ($t=0; $t < $offset; $t++) {
		echo '<td class="day">&nbsp;</td>';
	}
	/* start entering in the information */
	for ( $d = 1; $d <= $totaldays; $d++ )
	{
			$today = false;
			if (($d == date(j)) && ($calmonth == date(m)) && ($calyear == date(Y))) {
				$today = true;
			} 
			
			echo '<td class="day"' . ($today?' id="today" title="Today"':'') . '>';

			/* correct date format */
			$coredate = date( "Ymd", mktime( 0, 0, 0, $calmonth, $d, $calyear ) );
// 			showGrid($coredate);

			$link = false;

			if ($start_time[$coredate]) {
				foreach ( $start_time[$coredate] as $time => $data ) {
				    list($id) = each($data);
				    if($status[$id] < 2 || $status[$id] > 3) {
				    	$link = true;
				    }
				}
			}
			
			if($link) {
				echo '<a href="index.php?o=',$la,'&w=',$w,'&c=',$c,'&m=',$calmonth,'&a=',$d,'&y=',$calyear,'">', $d, '</a>';
			} else {
				echo $d;
			}

			echo "</td>";
			$offset++;
	
	     /* if we're on the last day of the week, wrap to the other side */
	     if ( $offset > 6 ) {
             $offset = 0;
             echo '</tr>';
             if ( $day < $totaldays )
                echo '<tr>';
	     }
	}
	
	/* fill in the remaining spaces for the end of the month, just to make it look
	   pretty */
	if ( $offset > 0 )
	        $offset = 7 - $offset;
	
	for ($t=0; $t < $offset; $t++) {
		echo "<td>&nbsp;</td>";
	}
	/* end the table */
	echo '</tr></table>';
	
	if(!$ajax_month) {
// 		if($_SESSION['id'] === 1) {
			echo '<div class="register_now"><a href="register.php">Start adding <strong>your</strong> events now!</a></div>';		
// 		}
		echo '<div class="notif_form"><form action="keyword_notifier.php" method="post">';
		echo '<p>Get notified when new events are added:</p>';
		echo '<label>Keyword(s): <input name="keywords"> <span>(seperate with commas)</span></label>';
		echo '<label>Email: <input type=email name="email"></label>';
		echo '<input type="submit" value="Submit">';
		echo '</form></div>';

		echo '<div class="ad">';
		// Show ad
		$_GET['zone'] = 'Misc-rect';
		include("/Volumes/ServerDocs/WebFolder-www/Documents/templates/ad.php");	
		mysql_select_db('calendar');
		
		echo '</div>';
	}
	echo '</div>';
}

if(!$ajax_month) {
	include "includes/header.php";
}

$thismonth = $y."-".$m;
$nextmonth =  $next["month"]["y"]."-".$next["month"]["m"];
grab($thismonth."-01",$nextmonth."-01",$c);

if(!$ajax_month) {
	showSearch();
}

showMonth($m,$y);

if($ajax_month) {
	die();
}

function showGrid($date) {
	global $title, $niceday, $start_time, $end_time, $venue, $city, $state, $cat, $color, $background, $ed, $usr, $o, $c, $m, $a, $y, $w, $lang, $ap, $status, $superpost;
	if ($start_time[$date]) {
		ksort($start_time[$date]);
		
		$curdate = null;
		
		$table_started = false;
		
		while (list($t) = each($start_time[$date])) {
			$i = 0;

			$d =  date_parse($t);
			if(time() > mktime(0, 0, 0, $d['month'], $d['day'] + 1, $d['year'])) {
				$expired = true;
				continue;
			} else {
				$expired = false;
			}

			while (list($id,$value) = each($start_time[$date][$t])) {
				
				// Hide proposed from regular users
				$can_edit = $ed[$id];
				$is_proposed = ($status[$id] == 2) || ($status[$id] == 3);
				if(!$can_edit && $is_proposed) {
					continue;
				}
			
			
				$newday = false;
			
				if ($i == 0) {
					if($curdate != $niceday[$date][$t][$id]) {
						$newday = true;
						$curdate = $niceday[$date][$t][$id];

						echo '<h3' . ($expired ? ' class="expired"' : '') . '>' .  $curdate . "</h3>\n";
						
						if($table_started) {
							echo "</table>\n";
						}
	
						echo '<table' . ($expired ? ' class="expired"' : '') . '>' . "\n";
						$table_started = true;

					}
				}
				
				
				echo '<tr>';

				echo '<th><span class="calcat' . $cat[$id] . '">•</span>' . $value . '</th>';
				
				echo "<td class='item'>";
				
				echo '<div>';
				
				echo "<div class=\"title\"><a class=\"popup\"  href=\"".$calendar_url."show_event.php?id=".$id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\"";

				echo ">".$title[$id]."</a></div>\n";
				if ($venue[$id]) {
					echo "<div class=\"venue\">".$venue[$id]."</div>\n";
					if ($city[$id]) {
						echo "<div class=\"location\">".$city[$id];
						if ($state[$id]) echo ", ".$state[$id];
						echo "</div>\n";
					}
				}
				echo "</div>";

				if ($ed[$id]==true) {
					echo "<div class=\"edit\">";
					if (($ap[$id]==true) && (($status[$id] == 2) || ($status[$id] == 3))) echo "[<a href=\"".$calendar_url."admin_actions.php?id=".$id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."&mode=".approve."\">".$lang["approve"]."</a>]&nbsp;&nbsp;";
					echo "[<a class='popup' href=\"edit_event.php?id=".$id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\">".$lang["edit"]."</a>]&nbsp;&nbsp;[<a href=\"".$calendar_url."delete_event.php?id=".$id."&o=".$o."&c=".$c."&m=".$m."&a=".$a."&y=".$y."&w=".$w."\">".$lang["delete"]."</a>]</div>\n";
				}
				echo "</td></tr>\n";
				$i++;
			}

		}
		
		echo "</table>\n";
		
	}
}

function showUpcoming () {
	global $start_time;
	if ($start_time) {
		ksort($start_time);
		echo '<div class="upc_wrap"><h3 class="cal_top"><a href="http://www.newsargus.com/admin/test/calendar/index.php?o=5">Upcoming events</a></h3><div class="upcoming">';

		foreach($start_time as $k=>$val) {
			showGrid($k);
		}

		echo '</div></div>';
	} else {
		echo '<p>No upcoming events within a month<p>';
	}
}

function showSearch() {
?>
<div id="cal_search">
	<form action="?">
		<label for="cal_search_q">Search events: </label>
		<input type="search" id="cal_search_q" autocomplete="off">
		<input type="submit" value="Go">
	</form>
	<div id="cal_search_results"></div>
</div>

<?php
}
//

// echo "hide:".$hideheader;
if (!$plusmonths) $plusmonths = 1;
if (!$plusdays) $plusdays = 0;
// if (!$hideheader) include "includes/header.php";

// Reset to today by ARPD
$y = date("Y");
$m = date("m");
$a = date("d");

$listend = date("Y-m-d", mktime(0,0,0,$m+$plusmonths,$a+$plusdays,$y));
grab($y."-".$m."-".$a,$listend,$c);


showUpcoming($m,$y);


if (!$hideheader) include "includes/footer.php";
?>
